/*
   This program just reads lines from standard input (stdin)
   and echos their reverse to standard output (stdout).

   If standard input is the console keyboard,
   use ^z (Control-z) to denote the end of file
   (and you must use ^z at the beginning of a line!).

   Try running this program from a command line using
   command line I/O redirections. For example
   C:\> java Reverse < Echo.java
*/
import java.util.Scanner;

public class Reverse
{
   public static void main(String[] args)
   {
      // Create a Scanner object to make it easier to use System.in
      Scanner scanner = new Scanner( System.in );

      while ( scanner.hasNextLine() )
      {
         String oneLine = scanner.nextLine();
         for (int i = oneLine.length() - 1; i >= 0; i--)
         {
            System.out.print( oneLine.charAt(i) );
         }
         System.out.println();
      }
   }
}